#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#include "RS232com1.h" 
#include "EFRframeDecode.h"
#include "options.h" 

extern uint16_t gapCount ;
extern uint8_t waitingForGap ;
extern volatile int8_t DAC1,DAC2 ;

uint8_t uartTimer ;
uint16_t uartShiftReg ;
uint8_t uartBitCount ;
uint8_t parityIsOdd ;


void softUartInit(){
  uartShiftReg=0 ;
  uartTimer=0 ;
  gapCount=0 ;
  parityIsOdd=0 ; 
  }

uint8_t uartStart ; // only used for display purposes

#define uartFullTime 5
#define uartHalfTime 4

void checkForStartBit(uint8_t input){
  if ( input != 0) { 
    uartTimer=uartHalfTime ;
    uartBitCount=0 ; 
    uartShiftReg=0 ; 
    uartStart=1 ; 
    parityIsOdd=0 ; 
    #ifdef DACoption1
	DAC1=250 ;
    #endif
    }
  }


void uartSample(uint8_t input){
  // sampling with 1000 samples/sec
  if (input!=0){
    gapCount=0 ;
	} 
   else { 
    gapCount++ ; 
	if (gapCount==50) { 
	  waitingForGap=0 ; // gap found
	  }
	}
  if (uartTimer==0) {
   	checkForStartBit(input) ;
    }
   else { 
    uartTimer++ ;
	}
  if (uartTimer>uartFullTime) {
    #ifdef DACoption1
    DAC1=uartBitCount*16 ; 
    #endif
    // a full bit time has elapsed again
    uartTimer -= uartFullTime ;
    // shift input into shiftregister
    if ( input == 0) { 
	  uartShiftReg=uartShiftReg+(1 << uartBitCount) ; 
	  }
	if (uartBitCount<10) {
	  if ( input==0){ parityIsOdd ^= 1 ;}
	  }
    // count bits
    uartBitCount++ ;
    if (uartBitCount==10) {
	  // we have enough bits
      uartShiftReg=uartShiftReg >> 1  ; // eliminate stop-bit and parity bit
	  uint8_t w=uartShiftReg ;
  	  msgFSMchar(w,parityIsOdd) ;

	 // uartPutc('0'+parityIsOdd) ;

	  }
    if (uartBitCount>10) {
	  // too many bits, restart 
	  uartBitCount=0 ; 
	  uartTimer=0 ; 
	  }
    }
  }

